<?php
require 'db.php';

class TelegramAPI{
    public $api, $updates, $chat_id, $message ;

    public function __construct($token) {
        $idbot = explode(":",$token);
        $this->token = $token;
        $this->botid = $idbot[0];
        $this->api = "https://api.telegram.org/bot$token";
        $this->updates = json_decode(file_get_contents('php://input'), TRUE); 
        $this->message = $this->updates["message"];
        $this->mexid = $this->message["message_id"];
        $this->chatid = $this->message["chat"]["id"];//di group reff ke group id
        $this->fromid = $this->message["from"]["id"]; //digroup ref ke person id
        $this->chtype = $this->message["chat"]["type"]; //private or group
        $this->input = $this->message["text"];
        $this->rtm = $this->updates["message"]["reply_to_message"]; //rtm = reply to message
        $this->repmex = $this->rtm["text"];
        $this->repcap = $this->rtm["caption"];
        $this->repid = $this->rtm["message_id"];
        $this->repfrom = $this->rtm["from"]["id"];
        $this->repfoto = $this->rtm["photo"]["2"]["file_id"];
        $this->repdraft = $this->rtm["document"]["file_id"];
        $this->fwdfrom = $this->message["forward_from"]["id"];
        
        $this->userid = $this->message["from"]["username"];
        $this->firstname = $this->message["from"]["first_name"];
        $this->lastname = $this->message["from"]["last_name"];
        $this->fullname = $this->firstname.' '.$this->lastname;
        $this->foto = $this->message["photo"]["2"]["file_id"];
        $this->capfoto = $this->message["caption"];
        // $this->capmex = $this->message["caption"];
        $this->cb = $this->updates["callback_query"];
        $this->cbid = $this->cb["message"]["message_id"];
        $this->cbfrom = $this->cb["from"]["id"];
        $this->cbfn = $this->cb["from"]["first_name"];
        $this->cbln = $this->cb["from"]["last_name"];
        $this->cbfullname = $this->cbfn.' '.$this->cbln;
        $this->cbdata = $this->cb["data"];
        $this->cbun = $this->cb["from"]["username"];
        $this->cbtext = $this->cb["message"]["text"];
        $this->cbcap = $this->cb["message"]["caption"];
        $this->cbfoto = $this->cb["message"]["photo"]["2"]["file_id"];
        $this->cbdoc = $this->cb["message"]["document"]["file_id"];
        $this->cbchtype = $this->cb["message"]["chat"]["type"]; //private or group
        $this->cbchatid = $this->cb["message"]["chat"]["id"]; //group id
        $this->draft = $this->message["document"]["file_id"];
        $this->repmex = $this->message["reply_to_message"]["text"];
        $this->repfrom = $this->message["reply_to_message"]["from"]["id"];
        $this->base = "https://image-charts.com/chart?cht=bvs&chd=s:theresadifferencebetweenknowingthepathandwalkingthepath&chs=978x300&chf=b0,lg,90,03a9f4,0,3f51b5,1&chxt=x,y&chan=1200,easeOutBack";
        $this->superadmin = "66351485";
        $this->devgrup = "-367057123";
        $this->db = new db;
        $this->connection = $this->db->conn(); // initialize once
        if (!empty($this->cbfrom)){
            $this->person = $this->cbfrom;
            $this->balaske = $this->cbchatid;
        } else {
            $this->person = $this->fromid;
            $this->balaske = $this->chatid;
        }

        if (!empty($this->repcap)){
            $this->repo = $this->repcap; //reply dispo
        } else {
            $this->repo = $this->repmex;
        }
        
        if ($this->chtype=="private" || $this->cbchtype=="private") {
            $this->isgroup="n";
        } else {$this->isgroup="y";}
    
    $crole = "select * from dbmember
    						where (chatid LIKE $this->person)
    						order by chatid DESC
    						";
    $rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
    	while ($row = $rrole->fetch_assoc()) {
    		    $this->wewenang = $row['role'];
    		    $this->idtim = $row['idtim'];
    		    $this->fullname = $row['fullname'];
    		    $this->idleader = $row['idleader'];
    		    $this->membership = $row['status'];
    		}
    
    }
   

    
    
    public function sendMessage($idchat,$text,$btn){
        if (!empty($btn)) {
        	file_get_contents($this->api."/sendMessage?chat_id=".$idchat."&text=".urlencode($text)."&reply_markup=".$btn);
        	file_get_contents($this->api."/sendMessage?chat_id=".$this->devgrup."&text=".urlencode($text)."&reply_markup=".$btn);
        } else {
        	file_get_contents($this->api."/sendMessage?chat_id=".$idchat."&text=".urlencode($text));
        	file_get_contents($this->api."/sendMessage?chat_id=".$this->devgrup."&text=".urlencode($text));
        }
    //     mysqli_query($this->connection,"insert into dblog(time,chatid,fullname,log) 
    // 	values(now(),'$this->person','$this->fullname','$text')");
    }
    
    public function sendphoto($idchat,$text,$pic,$btn){
        if (!empty($btn)) {
            file_get_contents($this->api."/sendPhoto?chat_id=".$idchat."&photo=".$pic."&caption=".urlencode($text)."&reply_markup=".$btn);
            file_get_contents($this->api."/sendPhoto?chat_id=".$this->devgrup."&photo=".$pic."&caption=".urlencode($text)."&reply_markup=".$btn);
        } else {
        	file_get_contents($this->api."/sendPhoto?chat_id=".$idchat."&photo=".$pic."&caption=".urlencode($text));
        	file_get_contents($this->api."/sendPhoto?chat_id=".$this->devgrup."&photo=".$pic."&caption=".urlencode($text));        	
        }
    }
    
    public function senddoc($idchat,$text,$doc,$btn){
        if (!empty($btn)) {
        	file_get_contents($this->api."/sendDocument?chat_id=".$idchat."&document=".$doc."&caption=".urlencode($text)."&reply_markup=".$btn);
    		file_get_contents($this->api."/sendDocument?chat_id=".$this->devgrup."&document=".$doc."&caption=".urlencode($text)."&reply_markup=".$btn);
        } else {
        	file_get_contents($this->api."/sendDocument?chat_id=".$idchat."&document=".$doc."&caption=".urlencode($text)); 
        	file_get_contents($this->api."/sendDocument?chat_id=".$this->devgrup."&document=".$doc."&caption=".urlencode($text)); 
        }
    }
 
     public function deletemex($chatid,$mexid) {
     	file_get_contents($this->api."/deleteMessage?chat_id=".$chatid."&message_id=".$mexid);   
     }
 
    public function start($task,$taskfoto,$photo,$doc){
        if (!empty($taskfoto)){
            $dispo = $taskfoto;
        } else {
            $dispo = $task;
        }
        
        if($this->wewenang == "LEAD") {
        $name=[];
        $idchat=[];
        $crole = "select * from dbmember
    						where (idtim LIKE $this->idtim and role LIKE '%STAF%' and status = 'aktif')
    						order by firstname ASC
    						";
    	$rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
    		while ($row = $rrole->fetch_assoc()) {
    		    $fname = $row['firstname'];
    		    $lname = $row['lastname'];
    		    $fullname = $row['fullname']; 
    		    $chatid = $row['chatid'];
    		    array_push($name,$fullname);
    		    array_push($idchat,$chatid);
    		}
        $buttonarray = [];
        $jumlahmember = count($idchat);
        for ($x = 0; $x < $jumlahmember; $x++) {
             $button = [["text" => $name[$x], "callback_data" => "[set dispo]/$idchat[$x]/$name[$x]"]];
            array_push($buttonarray, $button);
        }
        $welcome = "[Generating Disposisi]/\n[".$dispo."]/\n[Assign to :]";
        $keyboard = [
      			 "inline_keyboard" => $buttonarray
    				];
    	$keyboard = json_encode($keyboard, true);
        }
        elseif ($this->wewenang == "STAF") {
        $welcome = "[Generating Disposisi]/\n[".$dispo."]/\n[Are you sure?]";
        $keyboard = [
      			 "inline_keyboard" => [
      			                        [["text" => "Oke", "callback_data" => "[set dispo]/$this->chatid/$this->fullname"]],
        		                        [["text" => "Cancel", "callback_data" => "[cancel generate dispo]"]]
        		                      ]
    				];
    	$keyboard = json_encode($keyboard, true);
    	}
    	if (!empty($photo)) {
        	$this->sendphoto($this->balaske,$welcome,$photo,$keyboard);
    	} elseif (!empty($doc)) {
            $this->senddoc($this->balaske, $welcome, $doc, $keyboard);
        } else {
            $this->sendMessage($this->balaske, $welcome,$keyboard);
        }
    }

public function regdispo($daricb) {
        if (!empty($this->cbtext)){
            $disporaw = $this->cbtext;
        } else {
            $disporaw = $this->cbcap;
        }
        
	$explode = explode("]/\n[",$disporaw);
	$cb = explode("/",$this->cbdata);
    mysqli_query($this->connection,"insert into dbdispo(time,idtim,chatid,fullname,detail,status,idmex,photoid,draftid) 
	values(now(),'$this->idtim','$cb[1]','$cb[2]','$explode[1]','OPEN','$this->cbid','$this->cbfoto','$this->cbdoc')");
    $crole = "select * from dbdispo
						where (idmex LIKE $this->cbid)
						order by dispoid DESC
						";
	$rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
	while ($row = $rrole->fetch_assoc()) {
		    $masterid = $row['dispoid'];
		    }
    $detail = "\nId Dispo : ".$masterid."/Id Tim : ".$this->idtim."/\nTo : ".$cb[2]."/Chat Id : ".$cb[1]."/\nDisposisi : ".$explode[1];
    
    $fulltxt = "[DISPOSISI GENERATED]".$detail;
    
    $fulltxt2 = "[DISPOSISI SUCCESSFULLY GENERATED]".$detail;
    
    $qry= "update dbdispo
						set fulltxt = '$fulltxt'
						where idmex = '$this->cbid'";
    $update= mysqli_query($this->connection,$qry) or die (mysqli_error());
    mysqli_close($this->connection);
    $this->deletemex($daricb,$this->cbid);
        if (!empty($this->cbfoto)) {
            $this->sendphoto($cb[1],$fulltxt2,$this->cbfoto,"");
            $this->sendphoto($this->idleader,$fulltxt2,$this->cbfoto,"");
        } elseif (!empty($this->cbdoc)) {
            $this->senddoc($cb[1],$fulltxt2,$this->cbdoc,"");
            $this->senddoc($this->idleader,$fulltxt2,$this->cbdoc,"");
        } else {
            $this->sendmessage($cb[1],$fulltxt2,"");
            $this->sendmessage($this->idleader,$fulltxt2,"");
        }
    
    if ($this->isgroup=="y") {
        if (!empty($this->cbfoto)) {
            $this->sendphoto($this->balaske,$fulltxt2,$this->cbfoto,"");
        } elseif (!empty($this->cbdoc)) {
            $this->senddoc($this->balaske,$fulltxt2,$this->cbdoc,"");
        } else {
            $this->sendmessage($this->balaske,$fulltxt2,"");
        }
    }
    }

function stafdispo() {
    if ($this->wewenang == "LEAD") {
    $name=[];
    $idchat=[];
    $crole = "select * from dbmember
						where (idtim LIKE $this->idtim and role LIKE '%STAF%')
						order by firstname ASC
						";
	$rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
		while ($row = $rrole->fetch_assoc()) {
		    $fname = $row['firstname'];
		    $lname = $row['lastname'];
		    $fullname = $row['fullname']; 
		    $chatid = $row['chatid'];
		    array_push($name,$fullname);
		    array_push($idchat,$chatid);
		}
    $buttonarray = [];
    $jumlahmember = count($idchat);
    for ($x = 0; $x < $jumlahmember; $x++) {
         $button = [["text" => $name[$x], "callback_data" => "[Staf Dispo]/$idchat[$x]/$name[$x]"]];
        array_push($buttonarray, $button);
    }
    $welcome = "Dear ".$this->firstname." .\nChoose list disposisi from your team :";
    $keyboard = [
  			 "inline_keyboard" => $buttonarray
				];
	$keyboard = json_encode($keyboard, true);
	$this->sendmessage($this->chatid,$welcome,$keyboard);
    } else {
    $this->listdispo($this->chatid,$this->idtim);    //idtim ga perlu
    }
}

    
public function listdispo($orangnya){
    $myquery="select * from dbdispo 
			where (chatid LIKE '$orangnya' and status LIKE 'OPEN' and idtim LIKE '$this->idtim')
			order by dispoid ASC
			";
	$cdupl=mysqli_query($this->connection,$myquery) or die (mysqli_error()); //cek duplicate
		while($row = mysqli_fetch_array($cdupl)) {
  			$text = $row['fulltxt'];
  			$foto = $row['photoid'];
  			$doc = $row['draftid'];
  			if(!empty($foto)){
  			    $this->sendphoto($this->person,$text,$foto,"");
  			} elseif (!empty($doc)) {
  			    $this->senddoc($this->person,$text,$doc,"");
  			} else {
  			    $this->sendmessage($this->person,$text,"");  
  			}
		}
}

public function draftnaik($repmex,$draft,$foto,$input){
    $txt1 = str_replace("/\n","/",$repmex);
    $txt2 = str_replace(" : ","/",$txt1);
	$list = explode("/",$txt2);
	if ((string)$this->repfrom!==(string)$this->botid || (string)$this->chatid!==$list[7]){
        $this->sendmessage($this->chatid,"Not Authorized. Sepertinya Anda tidak mereply dispo dari bot atau tidak mereply dispo anda sendiri.","");
	} else {
	    $precaption = "[draft]/$list[5]/$list[7]/$list[1]/$list[3]/$this->mexid/$list[9]";
		$caption = substr($precaption,0,199);
		$qry = "insert into dbdraft(iddispo, idmex, chatid, idtim, text, status, fileid,imageid) 
			values('$list[1]','$this->mexid','$list[7]','$list[3]','$caption','OPEN','$draft','$foto');";
    	$qry .= "update dbdispo 
    				set status = 'wip'
    				where dispoid = $list[1]";
    	$update=mysqli_multi_query($this->connection,$qry) or die (mysqli_error());

		$keyboard = [
   			 "inline_keyboard" => [
    							  [["text" => urlencode("Approve & Arsip"), "callback_data" => "appdraft"]]
    							 // [["text" => "Net", "callback_data" => "net"]],
    							 // [["text" => "Revisi File + text", "callback_data" => "RFT"]],
    							 // [["text" => "Revisi without File", "callback_data" => "RWF"]]
    							 ]
						];
		$keyboard = json_encode($keyboard, true);
		
		$this->sendmessage($list[7],"Draft sukses dinaikkan","");    

    if(!empty($this->draft)){
        $this->senddoc($this->idleader,$caption,$draft,$keyboard);
    } elseif (!empty($this->foto)) {
        $this->sendphoto($this->idleader,$caption,$this->foto,$keyboard);
    }
        
	}
}    

public function draftlist() {
    if ($this->wewenang == "LEAD") {
	$keyboard = [
   	 "inline_keyboard" => [
						  [["text" => urlencode("Approve & Arsip"), "callback_data" => "appdraft"]]
						  //[["text" => "Revisi", "callback_data" => "revisi"]]
						 ]
				];
	$keyboard = json_encode($keyboard, true);
	$myquery="select * from dbdraft 
		where (status LIKE 'OPEN' and idtim LIKE '$this->idtim')
		order by draftid DESC
		";
	$cdupl=mysqli_query($this->connection,$myquery) or die (mysqli_error()); //cek duplicate
	while($row = mysqli_fetch_array($cdupl)) {
    	    $textpanjang = $row['text'];
      		$textall = substr($textpanjang,0,198);
      		$docid = $row['fileid'];
      		$imgid = $row['imageid'];
    	if(!empty($imgid)){
      			    $this->sendphoto($this->idleader,$textall,$imgid,"$keyboard");
      			} elseif (!empty($docid)) {
      			    $this->senddoc($this->idleader,$textall,$docid,"$keyboard");
      			}
    	}
    } else {
        $this->sendmessage($this->chatid,"Anda tidak memiliki otorisasi","");    
    }
}

public function revised() {
	$break = explode("/", $this->repo); //trigdr = trigger draft
	$qry ="update dbdispo 
				set status = 'OPEN'
				where dispoid = $break[3];
		  ";
	$qry .="update dbdraft 
				set status = 'CLOSE'
				where idmex = $break[5]
		  ";
	if (!empty($this->capfoto)) {
	    $pretex = "[".$this->capfoto."]\n".$this->repo;
	} else {
	    $pretex = "[".$this->input."]\n".$this->repo;
	}

	$tex = substr($pretex,0,199);
	$update=mysqli_multi_query($this->connection,$qry) or die (mysqli_error());
// 	if(!empty($GLOBALS[draft])){
// 	$urlb = $GLOBALS[website]."/sendDocument?chat_id=".$GLOBALS[idleader]."&document=".$GLOBALS[draft]."&caption=".urlencode($tex);
// 	file_get_contents($urlb);
// 	$urlc = $GLOBALS[website]."/sendDocument?chat_id=".$break[2]."&document=".$GLOBALS[draft]."&caption=".urlencode($tex);
// 	file_get_contents($urlc);    
// 	}
// 	elseif(!empty($GLOBALS[draftphoto])){
// 	$urlb = $GLOBALS[website]."/sendPhoto?chat_id=".$GLOBALS[idleader]."&photo=".$GLOBALS[draftphoto]."&caption=".urlencode($tex);
// 	file_get_contents($urlb);
// 	$urlc = $GLOBALS[website]."/sendPhoto?chat_id=".$break[2]."&photo=".$GLOBALS[draftphoto]."&caption=".urlencode($tex);
// 	file_get_contents($urlc);        
// 	}
    if(!empty($this->draft)){
        $this->senddoc($this->idleader,$tex,$this->draft,"");
        $this->senddoc($break[2],$tex,$this->draft,"");
    } elseif (!empty($this->foto)) {
        $this->sendphoto($this->idleader,$tex,$this->foto,"");
        $this->sendphoto($break[2],$tex,$this->foto,"");
    } elseif ((empty($this->foto))&&(empty($this->draft))) {
        $this->sendmessage($this->idleader,$tex,"");
        $this->sendmessage($break[2],$tex,"");
    }
}

public function arsip() {
	$break = explode("/", $this->cbcap, 8);
	$qrydate = "select * from dbdispo
	            where dispoid = $break[3]
	       ";
	$cdupl=mysqli_query($this->connection,$qrydate) or die (mysqli_error()); //cek duplicate
	while($row = mysqli_fetch_array($cdupl)) {
    	    $time = $row['time'];
    	}
	$qry="update dbdraft 
				set status = 'CLOSE'
				where idmex = $break[5];
		  ";
	$qry .="update dbdispo 
				set status = 'CLOSE', approvaldate = now(), leadtime = TIMEDIFF(now(),'$time')
				where dispoid = $break[3]
		  ";
	$tex = "[Archived] Following Disposisi has been approved :\n".$this->cbcap;
	$update=mysqli_multi_query($this->connection,$qry) or die (mysqli_error());
// 	$urlc = $GLOBALS[website]."/sendDocument?chat_id=".$GLOBALS[idleader]."&document=".$GLOBALS[cbdoc]."&caption=".urlencode($tex);
// 	file_get_contents($urlc);
// 	$urlc = $GLOBALS[website]."/sendDocument?chat_id=".$break[2]."&document=".$GLOBALS[cbdoc]."&caption=".urlencode($tex);
// 	file_get_contents($urlc);
	
	if(!empty($this->cbdoc)){
        $this->senddoc($this->idleader,$tex,$this->cbdoc,"");
        $this->senddoc($break[2],$tex,$this->cbdoc,"");
    } elseif (!empty($this->cbfoto)) {
        $this->sendphoto($this->idleader,$tex,$this->cbfoto,"");
        $this->sendphoto($break[2],$tex,$this->cbfoto,"");
    }
}
     
public function keyboardreg() {
    $keyboard = [
      			 "inline_keyboard" => [
      			                        [["text" => "Register as Team Leader", "callback_data" => "[reg_tl]"]],
        		                        [["text" => "Register as Team Member", "callback_data" => "[reg_tm]"]]
        		                      ]
    				];
    return $keyboard = json_encode($keyboard, true);
}

public function removekb() {
    	$keyboard = [
      			 "remove_keyboard" => true
						];
						
		$keyboard = json_encode($keyboard, true);
		$this->sendmessage($this->chatid,"remove keyboard",$keyboard);    
}

public function unichar($i) {
 return iconv('UCS-4LE','UTF-8',pack('V',$i));
}

public function registry(){
	mysqli_query($this->connection,"insert into dbtim(idleader,firstname,lastname,verifikasi,userid,role,teamname,status,bot) 
    	values('$this->person','$this->cbfn','$this->cbln','CLEAR','$this->cbun','LEAD','Team $this->person','aktif','$this->token')");
    $lastid = mysqli_insert_id($this->connection);
    mysqli_query($this->connection,"insert into dbmember(idtim,chatid,firstname,lastname,role,userid,fullname,idleader,status) 
    	values('$lastid','$this->person','$this->cbfn','$this->cbln','LEAD','$this->cbun','$this->cbfullname','$this->person','aktif')");
    fopen($lastid."a.png", "w") or die("Unable to open file!");
    fopen($lastid."b.png", "w") or die("Unable to open file!");
	mysqli_close($this->connection);
    $text = "Dear ".$this->cbfn.", Your registration is successful.\n\nFor the next step, invite your collegue to become your Team Member by forwarding Invitation Code below to them & tell them to forward the code back to the bot.";
    $this->sendmessage($this->person,$text,"");
    $down = "\xE2\xAC\x87 \xE2\xAC\x87 \xE2\xAC\x87 \xE2\xAC\x87";

    $this->sendmessage($this->person,$down,"");
    $inv = "[Inv-code]/[add-me]/team-$this->cbfn/$this->person";
    $this->sendmessage($this->person,$inv,"");
    $up = "\xE2\xAC\x86 \xE2\xAC\x86 \xE2\xAC\x86 \xE2\xAC\x86";
    $this->sendmessage($this->person,$up,"");
}

public function addme() {
    $explode = explode("/",$this->input) ;
    $idleader = $explode[3];
    $text = "Incoming New Team Member Request :\nUser ID : @$this->userid\nFirst Name : $this->firstname\nLast Name : $this->lastname";
    $tell = "Your request is waiting approval from your team leader. Please tell your team leader to approve your request";
    $profil = "@".$this->userid."/".$this->firstname."/".$this->lastname."/".$this->chatid; 
	$keyboard = [
    		"inline_keyboard" => [
    					  [["text" => "Approve", "callback_data" => "[addme-approved]/$profil"]],
    					  [["text" => "Reject", "callback_data" => "[addme-rejected]/$profil"]],
    					 ]
			];
	$keyboard = json_encode($keyboard, true);
   $this->sendmessage($idleader,$text,$keyboard);
   $this->sendmessage($this->chatid,$tell,"");
}

public function regtmok() {
	$select = "select idtim from dbmember
						where (chatid LIKE $this->cbfrom)
						order by chatid DESC
						";
		$rrole=mysqli_query($this->connection,$select) or die (mysqli_error());
		while ($row = $rrole->fetch_assoc()) {
		    $idtim = $row['idtim'];
		}
    $explode = explode("/",$this->cbdata);
    mysqli_query($this->connection,"insert into dbmember(idtim,chatid,firstname,lastname,role,userid,fullname,idleader,status) 
    	values('$idtim','$explode[4]','$explode[2]','$explode[3]','STAF','$explode[1]','$explode[2] $explode[3]','$this->cbfrom','aktif')");
    mysqli_close($this->connection);
	$tomember = "\nRegistration approved by Team Leader. Type /start to show keyboard.";
	$toleader = "Team Member : $explode[2]/$explode[3]/$explode[1] successfully added";
    $this->sendmessage($explode[4],$tomember,"");
    $this->sendmessage($this->cbfrom,$toleader,"");
}

public function sendbrowser(){
$id = "66351485";    
$document = new CurlFile(realpath("23.png"));
$params=[
    'chat_id'=>$id,
    'photo'=>$document,
];
$ch = curl_init($this->api . '/sendPhoto');
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER,
        ['Content-Type: multipart/form-data']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$result = curl_exec($ch);

curl_close($ch);
}

public function allsendchart(){
$idchat = [];
$tim = [];    
$select = "select * from dbtim
						where (status LIKE 'aktif' and bot LIKE '$this->token')
						order by idtim DESC
						";
		$rrole=mysqli_query($this->connection,$select) or die (mysqli_error());
		while ($row = $rrole->fetch_assoc()) {
		    $idtim = $row['idtim'];
		    $idleader = $row['idleader'];
		    array_push($idchat,$idleader);
		    array_push($tim,$idtim);
		}

// $id = "66351485";    
$sum = count($tim);
for ($x = 0; $x < count($sum); $x++) {
$document = [
    new CurlFile(realpath($tim[$x]."a.png")),
    new CurlFile(realpath($tim[$x]."b.png")),
    ];
foreach ($document as $dox) {
        $params=[
    'chat_id'=>$idchat[$x],
    'photo'=>$dox,
];
$ch = curl_init($this->api . '/sendPhoto');
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER,
        ['Content-Type: multipart/form-data']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$result = curl_exec($ch);

curl_close($ch);    
// $this->sendmessage($idchat[$x],"ini","");
    }

}

$params=[
    'chat_id'=>$this->idleader,
    'document'=>new CurlFile(realpath($this->idtim."-All-Assignment-Data.csv")),
];
$ch = curl_init($this->api . '/sendDocument');
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER,
        ['Content-Type: multipart/form-data']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$result = curl_exec($ch);

curl_close($ch);    
    
    
}

public function sendreport(){
$select = "select * from dbtim
						where (idleader LIKE '$this->person')
						order by idtim DESC
						";
		$rrole=mysqli_query($this->connection,$select) or die (mysqli_error());
		while ($row = $rrole->fetch_assoc()) {
		    $idtim = $row['idtim'];
		}

// $id = "66351485";    
$document = [
                new CurlFile(realpath($idtim."a.png")),
                new CurlFile(realpath($idtim."b.png"))
            ];
foreach ($document as $dox) {
                $params=[
                    'chat_id'=>$this->idleader,
                    'photo'=>$dox,
                ];
                $ch = curl_init($this->api . '/sendPhoto');
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLOPT_HTTPHEADER,
                        ['Content-Type: multipart/form-data']);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                $result = curl_exec($ch);
                
                curl_close($ch);    
                // $this->sendmessage($idchat[$x],"ini","");
            }

// $select = "SELECT dispoid,time,idtim,chatid,fullname,detail,status,idmex,approvaldate FROM dbdispo 
//         WHERE idtim LIKE $this->idtim"; 
//     $result = mysqli_query($this->connection,$select) or die (mysqli_error());
    $data[] = array('dispoid','waktu','chat id','nama','detail','status','id pesan','approval date');
    $crole = "SELECT dispoid,time,chatid,fullname,detail,status,idmex,approvaldate FROM dbdispo 
        WHERE idtim LIKE $this->idtim"; 
    $rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
    		while ($row = $rrole->fetch_assoc()) {
		        $data[] = array($row['dispoid'],$row['time'],$row['chatid'],$row['fullname'],$row['detail'],$row['status'],$row['idmex'],$row['approvaldate']);
    		}
    		
    $export = fopen($this->idtim."-All-Assignment-Data.csv", "w");
    fwrite($export, "sep=\t".PHP_EOL);
    foreach ($data as $row) {
      fputcsv($export, $row, "\t");
    }
    fclose($export);

$params=[
    'chat_id'=>$this->idleader,
    'document'=>new CurlFile(realpath($this->idtim."-All-Assignment-Data.csv")),
];
$ch = curl_init($this->api . '/sendDocument');
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER,
        ['Content-Type: multipart/form-data']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$result = curl_exec($ch);

curl_close($ch);    
    
    
}

public function teskeyboard() {
    	$keyboard = [
   			 "keyboard" => [
    							  [["text" => urlencode("\xF0\x9F\x9A\xA9 \xE2\x99\xA6 \xE2\x9C\x8F List Dispo Open")]],
      							  [["text" => urlencode("\xF0\x9F\x9A\xA9 \xE2\x99\xA6 \xF0\x9F\x93\x8B List Draft Leader")]],
      							  [["text" => urlencode("\xF0\x9F\x9A\xA9 \xE2\x99\xA6 \xF0\x9F\x9A\xA8 Show Report")]]

    							 ]
      		// 	 "remove_keyboard" => true

						];
						
		$keyboard = json_encode($keyboard, true);
		$this->sendmessage($this->chatid,"add keyboard",$keyboard);    
}

public function logchat() {
    if(!empty($this->input)) {
      mysqli_query($this->connection,"insert into dblog(time,chatid,fullname,input) 
    	values(now(),'$this->person','$this->fullname','$this->input')");
    	$chat = $this->fullname."/input/".$this->input;
    	$this->sendmessage($this->devgrup,$chat,"");
    }
    if(!empty($this->cbtext))
    {
        mysqli_query($this->connection,"insert into dblog(time,chatid,fullname,button) 
    	values(now(),'$this->cbfrom','$this->cbfullname','$this->cbtext')"); 
    	$chat = $this->cbfullname."/cb/".$this->cbtext;
    	$this->sendmessage($this->devgrup,$chat,"");
    }
    //     if(!empty($this->input)) {
    //   mysqli_query($this->connection,"insert into dblog(time,chatid,fullname,input,button,botrespon) 
    // 	values(now(),'$this->person','$this->fullname',' $this->cbtext','$this->input','$this->input')");        
    // }

}

// public function querytofile() {
//     $this->sendmessage($this->chatid,"oke","");
//     $select = "SELECT dispoid,time,idtim,chatid,fullname,detail,status,idmex,photoid,draftid FROM dbdispo 
//         WHERE idtim LIKE $this->idtim"; 
//     $result = mysqli_query($this->connection,$select) or die (mysqli_error());
//     $data[] = array('dispoid','waktu','chat id','nama','detail','status','id pesan','id foto','id draft');
//     $crole = "SELECT dispoid,time,chatid,fullname,detail,status,idmex,photoid,draftid FROM dbdispo 
//         WHERE idtim LIKE $this->idtim"; 
//     $rrole=mysqli_query($this->connection,$crole) or die (mysqli_error());
//     		while ($row = $rrole->fetch_assoc()) {
//     		    $id = $row['dispoid'];
//     		    $time = $row['time'];
//     		  //  array_push($data,$id);
// 		        $data[] = array($row['dispoid'],$row['time'],$row['chatid'],$row['fullname'],$row['detail'],$row['status'],$row['idmex'],$row['photoid'],$row['draftid']);
//     		}
    		
//     $export = fopen($this->idtim.".csv", "w");
//     fwrite($export, "sep=\t".PHP_EOL);
//     foreach ($data as $row) {
//       fputcsv($export, $row, "\t");
//     }
//     fclose($export);

// $params=[
//     'chat_id'=>$this->person,
//     'document'=>new CurlFile(realpath($this->idtim.".csv")),
// ];
// $ch = curl_init($this->api . '/sendDocument');
// curl_setopt($ch, CURLOPT_HEADER, false);
// curl_setopt($ch, CURLOPT_HTTPHEADER,
//         ['Content-Type: multipart/form-data']);
// curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
// curl_setopt($ch, CURLOPT_POST, 1);
// curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
// curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
// $result = curl_exec($ch);

// curl_close($ch);    
    
    
// }

public function switchlogic() {
// if ($this->chtype == "private" || $this->cbchtype == "private") {
switch (true) {
    // case (!empty($this->input)):
    // $this->log();
    
    case $this->input == "re3": 
    $this->sendbrowser();
    break;    
    
    case $this->cbdata=="[reg_tl]":
    $this->registry();
    break;
    
    case $this->fwdfrom==$this->botid&&strpos($this->input,'[Inv-code]/[add-me]')!==false :
    $this->addme();
    break;
    
    case strpos($this->cbdata,"[addme-approved]")!==false :
    $this->regtmok();
    break;
    
    case $this->membership !== "aktif":
    $this->sendmessage($this->person,"You are not registered yet.",$this->keyboardreg());
    break;
    
    case urlencode($this->input) == "%F0%9F%9A%A9+%E2%99%A6+%E2%9C%8F+List+Dispo+Open":
    $this->stafdispo();
    break;
    
    case urlencode($this->input) == "%F0%9F%9A%A9+%E2%99%A6+%F0%9F%93%8B+List+Draft+Leader":
    $this->draftlist();
    break;
    
    case urlencode($this->input) == "%F0%9F%9A%A9+%E2%99%A6+%F0%9F%9A%A8+Show+Report":
    $this->sendreport();
    break;
    
	case strpos($this->repo, '[draft]')!== false&&$this->wewenang=="LEAD" :
	$this->revised();
	break;
    
    case $this->input == "/start": 
    $this->teskeyboard();
    // $this->querytofile();
    break;
    
    case $this->input == "wea": 
    $this->sendmessage($this->chatid,$this->base,"");
    break;
    
	case $this->cbdata=="appdraft"&&$this->wewenang=="LEAD":
	$this->arsip();
	break;
	
	case $this->cbdata=="allsendchart"&&$this->cbfrom==$this->superadmin:
 	$this->allsendchart();
	break;
    
    case $this->isgroup=="n"&&empty($this->repid)&&empty($this->cbdata):
	$this->start($this->input,$this->capfoto,$this->foto,$this->draft); 
	break;
	
    case $this->isgroup=="y"&&!empty($this->repid)&&empty($this->cbdata)&&$this->input=="/go":
	$this->start($this->repmex,$this->repcap,$this->repfoto,$this->repdraft); 
	break;
	
    case strpos($this->cbdata,"[set dispo]/")!==false:
    if ($this->isgroup=="y"){$this->regdispo($this->cbchatid);}
    else {$this->regdispo($this->cbfrom);}
    break;
    
    case strpos($this->cbdata, '[Staf Dispo]') !== false:
    $stafid = explode("/",$this->cbdata);
    $this->listdispo($stafid[1]);
    break;
    
    case strpos($this->repo, '[DISPOSISI GENERATED]')!== false :
    $this->draftnaik($this->repo,$this->draft,$this->foto,$this->input);
    break;
    
    case strpos($this->repo, '[DISPOSISI SUCCESSFULLY GENERATED]')!== false :
    $this->sendmessage($this->person,"invalid [103] - Please reply from your List Dispo Open menu","");
    break;
    // default :
    // $this->sendmessage($this->person,"invalid [101] - Please check again your action","");
    }    
// } else {
//     switch (true) {
//     default :
//     $this->sendmessage($this->person,"invalid [102]","");
//     }
// }

}

// public function command($text) {
//     $mex = urlencode($text);
//     if (strpos($mex, '%F0%9F%9A%A9+%E2%99%A6') !== false) {
//         return "perintah";
//     } 
// }
    
}